/*
 * macro.h
 *
 * Created 7/6/2009 By Johnny Huynh
 *
 * Version 00.00.01 7/6/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */
 
 #ifndef MACRO_H
 #define MACRO_H
 
 #undef min     // to allow for use as function and variable names
 #undef max     // to allow for use as function and variable names
 
 #ifndef ZERO
 #define ZERO 0.0f
 #endif // ZERO
 
 #ifndef ONE
 #define ONE 1.0f
 #endif // ONE
 
 #ifndef MAX_NUMBER
 #define MAX_NUMBER std::numeric_limits<float>::max()
 #endif // MAX_NUMBER
 
 /**
  * MIN( a, b )
  */
 #ifndef MIN
 #define MIN( a, b ) ( (a) < (b) ? (a) : (b) )
 #endif // MIN
 
 /**
  * MAX( a, b )
  */
 #ifndef MAX
 #define MAX( a, b ) ( (a) > (b) ? (a) : (b) )
 #endif // MAX
 
 /**
  * ABS( a )
  */
 #ifndef ABS
 #define ABS( a ) ( (a) < 0 ? abs(a) : (a) )
 #endif // ABS
 
 /**
  * FABS( a )
  */
 #ifndef FABS
 #define FABS( a ) ( (a) < 0.0f ? (-1.0f * a) : (a) )
 #endif // FABS
 
 /**
  * SWAP( a, b )
  */
 #ifndef SWAP
 #define SWAP( a, b, type )         \
 {                                  \
    type temp( a );                 \
    a = b;                          \
    b = temp;                       \
 }
 #endif // SWAP
 
 #endif // MACRO_H